
Option Explicit

' 16 bit declarations
Declare Function GetInt16 Lib "Kernel" Alias "GetProfileInt" (ByVal lpAppName As String, ByVal lpKeyName As String, ByVal nDefault As Integer) As Integer
Declare Function GetString16 Lib "Kernel" Alias "GetProfileString" (ByVal lpAppName As String, ByVal lpKeyName As String, ByVal lpDefault As String, ByVal lpReturnedString As String, ByVal nSize As Integer) As Integer
Declare Function WriteString16 Lib "Kernel" Alias "WriteProfileString" (ByVal lpApplicationName As String, ByVal lpKeyName As Any, ByVal lpString As Any) As Integer
Declare Function DelString16 Lib "Kernel" Alias "WriteProfileString" (ByVal lpApplicationName As String, ByVal lpKeyName As Any, ByVal Value2 As Long) As Integer
Declare Function DelSection16 Lib "Kernel" Alias "WriteProfileString" (ByVal lpApplicationName As String, ByVal Value1 As Long, ByVal Value2 As Long) As Integer

Declare Function GetPrivateInt16 Lib "Kernel" Alias "GetPrivateProfileInt" (ByVal lpApplicationName As String, ByVal lpKeyName As String, ByVal nDefault As Integer, ByVal lpFileName As String) As Integer
Declare Function GetPrivateString16 Lib "Kernel" Alias "GetPrivateProfileString" (ByVal lpApplicationName As String, ByVal lpKeyName As String, ByVal lpDefault As String, ByVal lpReturnedString As String, ByVal nSize As Integer, ByVal lpFileName As String) As Integer
Declare Function WritePrivateString16 Lib "Kernel" Alias "WritePrivateProfileString" (ByVal lpApplicationName As String, ByVal lpKeyName As Any, ByVal lpString As Any, ByVal lpFileName As String) As Integer
Declare Function DelPrivateString16 Lib "Kernel" Alias "WritePrivateProfileString" (ByVal lpApplicationName As String, ByVal lpKeyName As Any, ByVal Value2 As Long, ByVal lpFileName As String) As Integer
Declare Function DelPrivateSection16 Lib "Kernel" Alias "WritePrivateProfileString" (ByVal lpApplicationName As String, ByVal Value1 As Long, ByVal Value2 As Long, ByVal lpFileName As String) As Integer

Function GetPrivateProfileInt (ByVal lpAppName As String, ByVal lpKeyName As String, ByVal nDefault As Integer, ByVal lpFileName As String) As Long

    GetPrivateProfileInt = GetPrivateInt16(lpAppName, lpKeyName, nDefault, lpFileName)

End Function

Function GetPrivateProfileString (ByVal lpAppName As String, ByVal lpKeyName As String, ByVal lpDefault As String, lpReturnedString As String, ByVal nSize As Integer, ByVal lpFileName As String) As Long

    Dim llLength As Long


    ' Adjust the buffer to the correct size
    lpReturnedString = String$(nSize, Chr$(0))

    llLength = GetPrivateString16(lpAppName, lpKeyName, lpDefault, lpReturnedString, nSize, lpFileName)

    ' Adjust the buffer to the size of the data retrieved
    lpReturnedString = Left$(lpReturnedString, llLength)
    
    GetPrivateProfileString = llLength

End Function

Function GetProfileInt (ByVal lpAppName As String, ByVal lpKeyName As String, ByVal nDefault As Integer) As Long

    GetProfileInt = GetInt16(lpAppName, lpKeyName, nDefault)

End Function

Function GetProfileString (ByVal lpAppName As String, ByVal lpKeyName As String, ByVal lpDefault As String, lpReturnedString As String, ByVal nSize As Integer) As Long

    Dim llLength As Long


    ' Adjust the buffer to the correct size
    lpReturnedString = String$(nSize, Chr$(0))

    llLength = GetString16(lpAppName, lpKeyName, lpDefault, lpReturnedString, nSize)

    ' Adjust the buffer to the size of the data retrieved
    lpReturnedString = Left$(lpReturnedString, llLength)
    
    GetProfileString = llLength

End Function

Function WritePrivateProfileInt (ByVal lpApplicationName As String, ByVal lpKeyName As String, ByVal lValue As Long, ByVal lpFileName As String) As Long

    ' An extended function, not provided by the API
    WritePrivateProfileInt = WritePrivateProfileString(lpApplicationName, lpKeyName, Trim$(Str$(lValue)), lpFileName)

End Function

Function WritePrivateProfileString (ByVal lpApplicationName As String, ByVal lpKeyName As String, ByVal lpString As String, ByVal lpFileName As String) As Long

    If lpKeyName = "" Then
        WritePrivateProfileString = DelPrivateSection16(lpApplicationName, 0, 0, lpFileName)
    Else
        If lpString = "" Then
            WritePrivateProfileString = DelPrivateString16(lpApplicationName, lpKeyName, 0, lpFileName)
        Else
            WritePrivateProfileString = WritePrivateString16(lpApplicationName, lpKeyName, lpString, lpFileName)
        End If
    End If

End Function

Function WriteProfileInt (ByVal lpApplicationName As String, ByVal lpKeyName As String, ByVal lValue As Long) As Long

    ' An extended function, not provided by the API
    WriteProfileInt = WriteProfileString(lpApplicationName, lpKeyName, Trim$(Str$(lValue)))

End Function

Function WriteProfileString (ByVal lpApplicationName As String, ByVal lpKeyName As String, ByVal lpString As String) As Long

    If lpKeyName = "" Then
        WriteProfileString = DelSection16(lpApplicationName, 0, 0)
    Else
        If lpString = "" Then
            WriteProfileString = DelString16(lpApplicationName, lpKeyName, 0)
        Else
            WriteProfileString = WriteString16(lpApplicationName, lpKeyName, lpString)
        End If
    End If

End Function

